
// called to load the JSON badge data from the Frenzic website using XMLHttpRequest
function loadScores()
{
	var name = widget.preferenceForKey(makeUniqueKey("name"));
	if (!name || name.length == 0)
	{
		name = widget.preferenceForKey("lastName");
	}
	
	var nameElement = document.getElementById('playerName');
	var rankElement = document.getElementById('playerRank');
	var scoreElement = document.getElementById('playerScore');
	var devotionElement = document.getElementById('playerDevotion');
	var avatarElement = document.getElementById('playerAvatar');

	if (name && name.length > 0)
	{
		nameElement.innerHTML = name;
		rankElement.innerHTML = "Loading...";
		scoreElement.innerHTML = "Loading...";
		devotionElement.innerHTML = "Loading...";
		avatarElement.innerHTML = "";

		var url = "http://frenzic.com/services/badge.php?name=" + name + "&type=json";
//		var url = "http://dev.frenzic.com/services/badge.php?name=" + name + "&type=json";
//		var url = "http://localhost:4000/services/badge.php?name=" + name + "&type=json";

		var object;
		var request = new XMLHttpRequest();
		request.open("GET", url, true);
		request.onreadystatechange = function ()
		{
			if (request.readyState == 4)
			{
				if (request.status == 200)
				{
					object = eval("(" + request.responseText + ")");

					rankElement.innerHTML = "Rank: " + object.rank;
					scoreElement.innerHTML = "Score: " + object.topscore;
					devotionElement.innerHTML = object.devotion;
					avatarElement.innerHTML = "<img src='" + object.avatar + "' />";
					
					devotionElement.className = "devotion" + object.devotion;
				}
				else
				{
					rankElement.innerHTML ="";
					scoreElement.innerHTML = "";
					devotionElement.innerHTML = "Player not found";

					devotionElement.className = "devotionNotFound";
				}

				request = null;
			}
		};
		request.send(null);
	}
	else
	{
		nameElement.innerHTML = "";
		rankElement.innerHTML ="";
		scoreElement.innerHTML = "";
		devotionElement.innerHTML = "No player specified";

		devotionElement.className = "devotionNotFound";
	}
}


// called when the body loads.  checks to see if there is a preference for this widget and if so, applies the preference to the widget.
function setup()
{
	if(window.widget)		// always check to make sure that you are running in Dashboard
	{
		var frontElement = document.getElementById("front");
		var backElement = document.getElementById("back");

		var nameElement = document.getElementById("nameInput");

		var name = widget.preferenceForKey(makeUniqueKey("name"));
		if (name && name.length > 0)
		{
			nameElement.value = name;
			frontElement.style.display="block";
			backElement.style.display="none";
		}
		else
		{
			var lastName = widget.preferenceForKey("lastName");
			if (lastName && lastName.length > 0)
			{
				nameElement.value = lastName;
			}
			else
			{
				nameElement.value = "Enter player name";
			}
			frontElement.style.display="none";
			backElement.style.display="block";
		}
	}
}

// called whenever there is a change to the name input field. stores the change as a preference.
function changeName(elem)
{	
	widget.setPreferenceForKey(elem.value, "lastName");
	widget.setPreferenceForKey(elem.value, makeUniqueKey("name"));
}

// called when the flipper is clicked and transitions from front view to back view
function showPrefs()
{
	var frontElement = document.getElementById("front");
	var backElement = document.getElementById("back");
	
	if (window.widget)
	{
		// freeze the widget so that we can change it without the user noticing
		widget.prepareForTransition("ToBack");	
	}
	
	frontElement.style.display="none";
	backElement.style.display="block";
	
	if (window.widget)
	{
		setTimeout ('widget.performTransition();', 0);	
	}
	
	// clean up the front - hide the circle behind the info button
	document.getElementById('fliprollie').style.display = 'none';
}


// called when the flipper is clicked and transitions from back view to front view
function hidePrefs()
{
	var frontElement = document.getElementById("front");
	var backElement = document.getElementById("back");
	
	if (window.widget)
	{
		// freeze the widget and prepare it for the flip from the back to the front
		widget.prepareForTransition("ToFront");
	}
	
	backElement.style.display="none";
	frontElement.style.display="block";
	
	if (window.widget)
	{
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
	}
	
	// reload the scores in case the name has changed
	loadScores();
}

// makes a preference key that is unique to the widget
function makeUniqueKey(key)
{
	return (widget.identifier + "-" + key);
}


//
// widget events
//

// called when the widget is shown in the Dashboard
function shown()
{
	loadScores();
}

// called when the widget is removed from the Dashboard
function removed()
{
//	var element = document.getElementById("nameInput");
	
	widget.setPreferenceForKey(null, makeUniqueKey("name"));
}

// called when the widget gets keyboard focus
function focused()
{
	document.getElementById('playerName').style.color = '#fc0'; 
}

// called when the widget loses keyboard focus
function blurred()
{
	document.getElementById('playerName').style.color = 'gray'; 
}

// register for widget events
if (window.widget)
{
	widget.onshow = shown;
	widget.onremove = removed;
	window.onfocus = focused;
	window.onblur = blurred;
}	

//
// preference flipper animation
//

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (! flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}